
Type TSpider

	Field _spiderTexture:TImage
	Field _upperLegTexture:TImage
	Field _lowerLegTexture:TImage
	
	Field _body:TBody
	Field _leftUpperLegBody:TBody
	Field _leftLowerLegBody:TBody
	Field _rightUpperLegBody:TBody
	Field _rightLowerLegBody:TBody
	
	Field _geom:TGeom
	Field _leftUpperLegGeom:TGeom
	Field _leftLowerLegGeom:TGeom
	Field _rightUpperLegGeom:TGeom
	Field _rightLowerLegGeom:TGeom
	
	Field _leftShoulderRevoluteJoint:TRevoluteJoint
	Field _leftShoulderAngleJoint:TAngleJoint
	
	Field _rightShoulderRevoluteJoint:TRevoluteJoint
	Field _rightShoulderAngleJoint:TAngleJoint
	
	Field _leftKneeRevoluteJoint:TRevoluteJoint
	Field _leftKneeAngleJoint:TAngleJoint
	
	Field _rightKneeRevoluteJoint:TRevoluteJoint
	Field _rightKneeAngleJoint:TAngleJoint
	
	Field _spiderBodyRadius:Int = 20
	Field _upperLegSize:Vector2 = Vector2.Create(40, 12) 'x=width,y=height
	Field _lowerLegSize:Vector2 = Vector2.Create(30, 12)
	
	Field _collisioncategory:Int = CollisionCategories.All
	Field _collidesWith:Int = CollisionCategories.All
	Field _collisionGroup:Int
	
	Field _position:Vector2 = Vector2.Zero()
	
	Method GetBody:TBody()
		Return _body
	End Method
	
	Method GetCollisionCategory:Int()
		Return _collisionCategory
	End Method
	
	Method SetCollisionCategory(value:Int)
		_collisionCategory = value
	End Method
	
	Method GetCollidesWith:Int()
		Return _collidesWith
	End Method
	
	Method SetCollidesWith(value:Int)
		_collidesWith = value
	End Method
	
	Method GetCollisionGroup:Int()
		Return _collisionGroup
	End Method
	
	Method SetCollisionGroup(value:Int)
		_collisionGroup = value
	End Method
	
	Function Create:TSpider(position:Vector2)
		Local spider:TSpider = New TSpider
		spider._position.Set(position)
		Return spider
	End Function
	
	Method ApplyForce(force:Vector2)
		_body.ApplyForce(force)
	End Method
	
	Method ApplyTorque(torque:Float)
		_body.ApplyTorque(torque)
	End Method
	
	
	Method Load(physics:TPhysicsSimulator)
		_spiderTexture = TDrawingHelper.CreateCircleTexture(_spiderBodyRadius, TColor.White, TColor.Black)
		_upperLegTexture = TDrawingHelper.CreateRectangleTexture(_upperLegSize.X, _upperLegSize.Y, TColor.White, TColor.Black)
		_lowerLegTexture = TDrawingHelper.CreateRectangleTexture(_lowerLegSize.X, _lowerLegSize.Y, TColor.Red, TColor.Black)
		MidHandleImage(_spiderTexture)
		MidHandleImage(_upperLegTexture)
		MidHandleImage(_lowerLegTexture)
		
		_body = TBodyFactory.CreateCircleBody(physics, _spiderBodyRadius, 1)
		_body.SetPosition(_position)
		_body.SetStatic(False)

		_leftUpperLegBody = TBodyFactory.CreateRectangleBody(physics, _upperLegSize.X, _upperLegSize.Y, 1)
		_leftUpperLegBody.SetPosition(Vector2.Create(_body._position.X - _spiderBodyRadius - _upperLegSize.X / 2, _body._position.Y))
		
		_leftLowerLegBody = TBodyFactory.CreateRectangleBody(physics, _lowerLegSize.X, _lowerLegSize.Y, 1)
		_leftLowerLegBody.SetPosition(Vector2.Create(_body._position.X - _spiderBodyRadius - _upperLegSize.X - _lowerLegSize.X / 2, _body._position.Y))
		
		_rightUpperLegBody = TBodyFactory.CreateRectangleBody(physics, _upperLegSize.X, _upperLegSize.Y, 1)
		_rightUpperLegBody.SetPosition(Vector2.Create(_body._position.X + _spiderBodyRadius + _upperLegSize.X / 2, _body._position.Y))
		
		_rightLowerLegBody = TBodyFactory.CreateRectangleBody(physics, _lowerLegSize.X, _lowerLegSize.Y, 1)
		_rightLowerLegBody.SetPosition(Vector2.Create(_body._position.X + _spiderBodyRadius + _upperLegSize.X + _lowerLegSize.X / 2, _body._position.Y))
		
		' load geometries
		_geom = TGeomFactory.CreateCircleGeom(physics, _body, _spiderBodyRadius, 14)
		_geom.SetCollisionGroup(_collisionGroup) 

		_leftUpperLegGeom = TGeomFactory.CreateRectangleGeom(physics, _leftUpperLegBody, _upperLegSize.X, _upperLegSize.Y)
		_leftLowerLegGeom = TGeomFactory.CreateRectangleGeom(physics, _leftLowerLegBody, _lowerLegSize.X, _lowerLegSize.Y)
		_rightUpperLegGeom = TGeomFactory.CreateRectangleGeom(physics, _rightUpperLegBody, _upperLegSize.X, _upperLegSize.Y)
		_rightLowerLegGeom = TGeomFactory.CreateRectangleGeom(physics, _rightLowerLegBody, _lowerLegSize.X, _lowerLegSize.Y)
		_leftUpperLegGeom.SetCollisionGroup(_collisiongroup)
		_leftLowerLegGeom.SetCollisionGroup(_collisiongroup)
		_rightUpperLegGeom.SetCollisionGroup(_collisiongroup)
		_rightLowerLegGeom.SetCollisionGroup(_collisiongroup) 
'		
		' load joints
		Local spiderRad:Vector2 = Vector2.Create(_spiderBodyRadius, 0)
		_leftShoulderRevoluteJoint = TJointFactory.CreateRevoluteJoint(physics, _body, _leftUpperLegBody, Vector2.SubtractVectors(_body._position, spiderRad))
		_leftShoulderAngleJoint = TJointFactory.CreateAngleJoint(physics, _body, _leftUpperLegBody, -.4)
		_leftShoulderAngleJoint.SetMaxImpulse(300)
		
		_rightShoulderRevoluteJoint = TJointFactory.CreateRevoluteJoint(physics, _body, _rightUpperLegBody, Vector2.AddVectors(_body._position, spiderRad))
		_rightShoulderAngleJoint = TJointFactory.CreateAngleJoint(physics, _body, _rightUpperLegBody, .4)
		_rightSHoulderAngleJOint.SetMaxImpulse(300)
		
		Local kneePos1:Vector2 = Vector2.Create(_body._position.X - _spiderBodyRadius - _upperLegSize.X, _body._position.Y)
		Local kneePos2:Vector2 = Vector2.Create(_body._position.X + _spiderBodyRadius + _upperLegSize.X, _body._position.Y)

		
		_leftKneeRevoluteJoint = TJointFactory.CreateRevoluteJoint(physics, _leftUpperLegBody, _leftLowerLegBody, kneePos1)
		_leftKneeAngleJoint = TJointFactory.CreateAngleJoint(physics, _leftUpperLegBody, _leftLowerLegBody, - _kneeTargetAngle)
		_leftKneeAngleJoint.SetMaxImpulse(300)
		
		_rightKneeRevoluteJoint = TJointFactory.CreateRevoluteJoint(physics, _rightUpperLegBody, _rightLowerLegBody, kneePos2)
		_rightKneeAngleJoint = TJointFactory.CreateAngleJoint(physics, _rightUpperLegBody, _rightLowerLegBody, _kneeTargetAngle)
		_rightKneeAngleJoint.SetMaxImpulse(300)
	End Method
	
	Field _kneeFlexed:Int = False
	Field _kneeTargetAngle:Float =.4
	Field _shoulderTargetAngle:Float =.2
	Field _s:Float = 0
	Method Update(delta:Float)
		_s:+delta
		If _s > 4 Then
			_s = 0
			_kneeFlexed = Not _kneeFlexed
			If _kneeFlexed Then
				_kneeTargetAngle = 1.4
				_shoulderTargetAngle = 1.2
			Else
				_kneeTargetAngle =.4
				_shoulderTargetAngle =.2
			End If
			
		End If
		
		_leftKneeAngleJoint.SetTargetAngle(- _kneeTargetAngle)
		_rightKneeAngleJoint.SetTargetAngle(_kneeTargetAngle)
		
		_leftShoulderAngleJoint.SetTargetAngle(- _shoulderTargetAngle)
		_rightShoulderAngleJoint.SetTargetAngle(_shoulderTargetAngle)
	End Method
	
	Method Draw()
		_DrawGeom(_leftUpperLegGeom, _upperLegTexture) 
		_DrawGeom(_leftLowerLegGeom, _lowerLegTexture)
		_DrawGeom(_rightUpperLegGeom, _upperLegTexture)
		_DrawGeom(_rightLowerLegGeom, _lowerLegTexture)
		_DrawGeom(_geom, _spiderTexture)
		SetOrigin(0, 0)
		SetRotation(0)
	End Method
	
	Method _DrawGeom(geom:TGeom, texture:TImage)
		SetOrigin(geom._position.X, geom._position.Y)
		SetRotation(MathHelper.ToDegrees(geom.GetRotation()))
		DrawImage(texture, 0, 0)
	End Method
End Type
